var theCanvas,logoArt,logo
var gameBg, cloud1Art,cloud2Art, cloud3Art, cloud4Art,cloud1,cloud2,cloud3,cloud4
var tileSize = 16
var bgTest
var state
var playerArt1Front,playerArt1Back, playerArt1L, playerArt1R, player1
var cursorImg, myCursor, cursorW, cursorH

var gameStart = false 
var playerGender = "F"


// Outdoor Tiles
var outdoorTilesArtwork, outdoorMap, outdoorTiles,level
let inv = 234 // invisible tile
let soil = 680
var outdoorLevel1 = [
    // 1  2   3   4   5   6   7   8   9  10  11  12  13  14  15  16  17  18  19  20  21  22  23  24  25  26  27  28  29  30  31  
    [562,562,562,562,562,562,562,562,563,inv,inv,inv,inv,inv,inv,inv,inv,inv,494,383,384,384,385,386,inv,inv,inv,inv,386,inv], // fences 1
    [inv,inv,inv,inv,inv,inv,inv,inv,588,inv,inv,inv,inv,inv,inv,inv,inv,inv,519,inv,inv,inv,inv,358,358,359,359,360,inv,inv], //fences 2
    [10 ,11 ,12 ,10 ,11 ,12 ,10 ,11 ,12,inv,inv,inv,inv,inv,inv,inv,542,543,544,inv,inv,inv,inv,383,383,384,384,385,386,inv],
    [35 ,36 ,37 ,35 ,36 ,37 ,35 ,36 ,37,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,386,inv],
    [60 ,61 ,62 ,60 ,61 ,62 ,60 ,61 ,62 ,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,386,inv],
    [85 ,86 ,87 ,85 ,86 ,87 ,85 ,86 ,87 ,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,386,inv],
    [inv,111,inv,110,111,inv,inv,111,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,362,363,inv,inv,inv,inv,inv,386,inv],
    [inv,136,inv,inv,136,inv,inv,136,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,387,388,inv,inv,inv,inv,inv,436,383],
    [inv,inv,361,358,359,359,359,359,360,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv],
    [inv,inv,411,383,384,384,384,384,385,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv],
    [2  ,inv,411,88 ,89 ,253,254,254,200,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv],
    [27 ,inv,386,113,114,175,218,219,225,227,488,227,226,226,226,227,227,226,226,226,227,226,226,227,88 ,89 ,361,439,413,414],
    [52,inv,411,88 ,89 ,203,180,205,202,226,226,226,227,226,226,soil,soil,soil,soil,226,226,226,227,226,113,114,386,inv,42,43],
    [77,inv,386,113,114,226,226,227,226,226,226,227,226,226,227,soil,soil,soil,soil,226,226,226,227,226,88 ,89 ,386,inv,inv,inv],
    [inv,inv,386,88 ,89 ,226,226,227,226,226,226,227,226,206,227,226,226,226,227,226,226,226,227,226,113,114,386,inv,inv,inv],
    [inv,inv,386,113,114,226,226,227,226,226,226,227,226,226,227,226,226,226,227,226,226,226,227,226,88 ,89 ,386,inv,inv,inv],
    [inv,inv,386,88 ,89 ,226,226,226,226,226,226,227,226,226,227,226,226,206,227,226,226,226,227,226,113,114,386,inv,inv,inv],
    [1  ,2  ,386,113,114,226,226,206,227,226,226,227,226,488,227,226,226,226,227,488,226,226,226,227,88 ,89 ,386,inv,inv,inv],
    [26 ,27 ,386,88 ,89 ,226,226,227,226,226,226,227,226,226,227,226,226,226,227,226,226,226,227,226,113,114,386,inv,inv,inv],
    [51 ,52 ,386,113,114,226,226,226,226,227,226,227,206,226,227,226,226,226,227,226,226,226,488,226,88 ,89 ,386,inv,inv,inv],
    [76 ,77 ,386,88 ,89 ,226,226,6  ,7  ,8  ,9  ,227,226,226,227,226,226,226,227,226,226,226,226,226,113,114,386,inv,inv,inv],
    [101,102,411,113,114,226,226,31 ,32 ,33 ,34 ,227,226,226,227,226,206,226,227,226,226,226,227,226,88 ,89 ,386,inv,inv,inv],
    [126,inv,411,358,359,359,360,56 ,57 ,58 ,59 ,358,359,359,359,359,360,226,227,226,226,226,227,226,113,114,411,inv,inv,inv],
    [inv,inv,436,383,384,384,385,81 ,82 ,83 ,84 ,383,384,384,384,384,385,226,227,226,226,226,227,226,226,227,436,inv,inv,inv],
    [inv,88 ,89 ,inv,inv,inv,inv,106,107,108,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,1182,1183,1183,1184,588,inv,inv],
    [inv,113,114,19 ,20 ,inv,inv,inv,132,133,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,1207,inv,inv,inv,inv,inv,inv,inv],
    [inv,inv,inv,inv,45 ,46 ,inv,inv,157,158,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,1257,inv,inv,inv,inv,inv,inv,inv],
    [inv,inv,inv,inv,inv,71 ,13 ,14 ,15 ,414,414,413,88 ,89 ,13 ,14 ,15 ,88 ,89 ,438,inv,inv,439,inv,inv,inv,inv,inv,inv,inv],
    [inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv],
    [inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv],
    [inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv],
    [inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv]
]

var outdoorLevel2 = [
    [inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,759,759,759,759,759,759,inv,inv,inv,inv,inv,inv],
    [inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,759,inv,inv,inv,inv,759,inv,inv,inv,inv,inv,inv],
    [inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,759,759,759,inv,inv,inv,inv,759,759,759,759,759,759,inv],
    [inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,759,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,759,inv],
    [inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,759,759,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,759,inv],
    [inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,759,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,759,inv],
    [inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,759,inv,inv,inv,759,759,inv,inv,inv,inv,inv,759,inv],
    [inv,inv,inv,inv,inv,inv,inv,inv,759,759,759,759,759,759,759,759,759,759,inv,inv,inv,759,759,inv,inv,inv,inv,inv,759,759],
    [inv,inv,inv,inv,inv,inv,inv,inv,759,inv,inv,inv,inv,inv,inv,inv,inv,759,759,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv],
    [inv,inv,inv,inv,759,759,759,759,759,759,759,759,759,inv,inv,inv,759,759,759,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv],
    [inv,inv,inv,inv,759,inv,193,194,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv],
    [inv,inv,inv,inv,759,inv,759,759,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,759,759,759,759,759,759],
    [inv,inv,inv,inv,759,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,759,inv,inv,inv,inv,inv],
    [inv,inv,inv,inv,759,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,759,inv,inv,inv,inv,inv],
    [inv,inv,inv,inv,759,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,759,inv,inv,inv,inv,inv],
    [inv,inv,inv,inv,759,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,759,inv,inv,inv,inv,inv],
    [inv,inv,inv,inv,759,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,759,inv,inv,inv,inv,inv],
    [inv,inv,inv,inv,759,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,759,inv,inv,inv,inv,inv],
    [inv,inv,inv,inv,759,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,759,inv,inv,inv,inv,inv],
    [inv,inv,inv,inv,759,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,759,inv,inv,inv,inv,inv],
    [inv,inv,inv,inv,759,inv,inv,759,759,759,759,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,759,inv,inv,inv,inv,inv],
    [inv,inv,inv,inv,759,inv,inv,759,inv,inv,759,759,759,759,759,759,759,inv,inv,inv,inv,inv,inv,inv,759,inv,inv,inv,inv,inv],
    [inv,inv,inv,inv,759,759,759,759,inv,inv,759,759,759,759,759,759,759,inv,inv,inv,inv,inv,inv,inv,759,759,759,inv,inv,inv],
    [inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,759,759,759,759,759,759,759,inv,inv,inv,inv,inv,inv,inv,inv,inv,759,inv,inv,inv],
    [inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,759,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,759,759,759,759,759,inv,inv,inv],
    [inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,759,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,759,inv,inv,inv,inv,inv,inv,inv],
    [inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,759,759,759,759,759,759,759,759,759,inv,inv,759,inv,inv,inv,inv,inv,inv,inv],
    [inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,759,inv,inv,759,inv,inv,inv,inv,inv,inv,inv],
    [inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,759,759,759,759,inv,inv,inv,inv,inv,inv,inv],
    [inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv],
    [inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv],
    [inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv,inv],
]

// Crops
var cropMap

// tools
var hoeArt, pickaxeArt, wateringCanArt
var hoe, pickaxe, wateringCan
var waterStation

// User Interface
var panel
var ui = []
var mode = 0
var alert = false
var currentSeed, alertMsg; 
var seedsName

// seeds
var cauliflowerSeedArt, cauliflowerArt, cauliflowerIcon, cauliflower
var kaleSeedArt, kaleArt, kaleIcon, kale; 
var bokchoySeedArt,bokchoyArt, bokchoyIcon, bokchoy
var crops = []
var cropsPos = []

// currency
var goldArt, clockfaceArt, gold, totalGold, totalMade;
var shopArt, shopPanel,leftArrowArt, rightArrowArt, okBtnArt, closeBtnArt,ownerArt,dialogueArt, board
var c_purchased = 0, k_purchased = 0, b_purchased = 0
var c_sold = 0, k_sold = 0, b_sold = 0

// Sounds
var buySound, closeSound, hoeSound, mouseClickSound
var shopSound,pickaxeSound,sellSound,spingSound,waterSound,refillSound,shovelSound
var warningSound, seedSound, stepSound, gameStartSound, maleSound, femaleSound

let logoheight = 185
let logox = 130
let direction = true
let next = false
let proceed = false



// PRELOAD ----------------------------------------------------------------------------------------------------------------------
function preload(){
    logoArt = loadImage("assets/ui/logo.png")
    gameBg = loadImage("assets/background.png")
    cloud1Art = loadImage("assets/gamestart/cloud1.png")
    cloud2Art = loadImage("assets/gamestart/cloud2.png")
    cloud3Art = loadImage("assets/gamestart/cloud3.png")
    cloud4Art = loadImage("assets/gamestart/cloud4.png")

    // Tile Maps
    outdoorTilesArtwork = loadImage("assets/sprites/outdoors.png")
    outdoorMap = loadImage("assets/outdoorMap.png")
    cropMap = loadImage("assets/sprites/crops.png")

    // Player Art
    playerArt1Front = loadImage("assets/players/player1/front1.png")
    playerArt1Back = loadImage("assets/players/player1/back1.png")
    playerArt1L = loadImage("assets/players/player1/left1.png")
    playerArt1R = loadImage("assets/players/player1/right1.png")

    playerArt2Front = loadImage("assets/players/player1/front2.png")
    playerArt2Back = loadImage("assets/players/player1/back2.png")
    playerArt2L = loadImage("assets/players/player1/left2.png")
    playerArt2R = loadImage("assets/players/player1/right2.png")

    playerArt1 = loadImage("assets/players/player1/profile1.1.png")
    playerArt1smile = loadImage("assets/players/player1/profile1.2.png")
    playerArt2 = loadImage("assets/players/player1/profile2.1.png")
    playerArt2smile = loadImage("assets/players/player1/profile2.2.png")


    // Sound files
    buySound = loadSound("assets/sounds/buySuccess.wav")
    closeSound = loadSound("assets/sounds/close.wav")
    hoeSound = loadSound("assets/sounds/hoe.wav")
    mouseClickSound = loadSound("assets/sounds/mouseClick.wav")
    matureSound = loadSound("assets/sounds/jingle1.wav")
    pickaxeSound = loadSound("assets/sounds/pickaxe.wav")
    sellSound = loadSound("assets/sounds/sellSuccess.wav")
    spingSound = loadSound("assets/sounds/spring_day.wav")
    waterSound = loadSound("assets/sounds/wateringCan.wav")
    refillSound = loadSound("assets/sounds/water_refill.wav")
    shovelSound = loadSound("assets/sounds/shovel.wav")
    warningSound = loadSound("assets/sounds/warning.wav")
    seedSound = loadSound("assets/sounds/seeds.wav")
    stepSound = loadSound("assets/sounds/snowyStep.wav")
    gameStartSound = loadSound("assets/sounds/gameStart.wav")
    femaleSound = loadSound("assets/sounds/helloFemale.ogg")
    maleSound = loadSound("assets/sounds/helloMale.wav")

    // Tools Art
    hoeArt = loadImage("assets/tools/hoe.png")
    wateringCanArt = loadImage("assets/tools/watering_can.png")
    pickaxeArt = loadImage("assets/tools/pickaxes.png")

    // seeds
    cauliflowerSeedArt = loadImage("assets/seeds/cauliflower/cauliflowerSeed.png")
    kaleSeedArt = loadImage("assets/seeds/kale/kaleSeed.png")
    bokchoySeedArt = loadImage("assets/seeds/bokchoy/bokchoySeed.png")

    // load images
    cauliflowerArt = loadImage("assets/seeds/cauliflower/cauliflower_ripe.png")
    kaleArt = loadImage("assets/seeds/kale/kale_ripe.png")
    bokchoyArt = loadImage("assets/seeds/bokchoy/bokchoy_ripe.png")

    // currency
    goldArt = loadImage("assets/ui/gold.png")
    clockfaceArt = loadImage("assets/ui/clockface.png")

    // shop
    shopArt = loadImage("assets/ui/shop_panel.png")
    leftArrowArt = loadImage("assets/ui/left_arr.png")
    rightArrowArt= loadImage("assets/ui/right_arr.png")
    okBtnArt = loadImage("assets/ui/okBtn.png")
    closeBtnArt = loadImage("assets/ui/closeBtn.png")
    ownerArt = loadImage("assets/ui/owner.png")
    dialogueArt = loadImage("assets/ui/dialogue.png")
    board = loadImage("assets/ui/board.png")

    // cursor
    cursorImg = loadImage("assets/ui/cursor.png")
}


// SETUP ----------------------------------------------------------------------------------------------------------------------
function setup(){
    theCanvas = createCanvas(480,450)
    imageMode(CORNER)

    noCursor()

    // if(gameStart == true){
        spingSound.play()
        spingSound.loop()
    // }
    

    cloud1 = new Clouds(100,100,150,80)
    cloud2 = new Clouds(200, 250,200,100)
    cloud3 = new Clouds(400,50,150,80)
    cloud4 = new Clouds(300, 185,100,70)

    profile1 = new Character(500,200,1,playerArt1)
    profile2 = new Character(670,200,2,playerArt2)

    // player
    player1 = new Player(250,250)
    if(player1.gender == "F"){
        this.graphic = playerArt1Front
    }else if(player1.gender =="M"){
        this.graphic = playerArt2Front;
    }
    shop = new Shop(353,116)
    waterStation = new WaterBox(112,183)

    // Tools
    hoe = new Tools(hoeArt,120,420)
    pickaxe = new Tools(pickaxeArt,150,420)
    wateringCan = new Tools(wateringCanArt,180,420)
    // waterCount = 5

    // seeds
    cauliflowerSeed = new Seeds(cauliflowerSeedArt,210,420)
    cauliflowerSeed.price = 8
    cauliflowerIcon = new Seeds(cauliflowerArt,300,420)
    cauliflowerIcon.price = 10
    
    kale = new Seeds(kaleSeedArt,240,420)
    kale.price = 8
    kaleIcon = new Seeds(kaleArt,330,420)
    kaleIcon.price = 10
    
    bokchoy = new Seeds(bokchoySeedArt,270,420)
    bokchoy.price = 10
    bokchoyIcon = new Seeds(bokchoyArt,360,420)
    bokchoyIcon.price = 12

    cauliflowerSeed.amount = 5
    kale.amount = 5
    bokchoy.amount = 5
    cauliflowerIcon.amount = 0
    kaleIcon.amount = 0
    bokchoyIcon.amount = 0

    ui.push(
        hoe,pickaxe,wateringCan,
        cauliflowerSeed,
        kale,
        bokchoy,
        cauliflowerIcon,
        kaleIcon,
        bokchoyIcon
    )


    // UI
    panel = new UserPanel(240,420)
    myCursor = cursorImg
    cursorW = 10
    cursorH = 20
    

    repositionCanvas();
}


// DRAW ----------------------------------------------------------------------------------------------------------------------
function draw(){

    // pre-game
    if(gameStart == false){

        image(gameBg,-200,0,800,450)


        if(next == false && proceed == false){
            // logo
            if(direction == true){
                if(logoheight <= 200 && logoheight > 175){
                    logoheight -= 0.25
                }else {
                    direction = false
                }
            
            }
            else {
                if(logoheight >= 175 && logoheight < 200){
                    logoheight += 0.25
                }else {
                    direction = true
                }
            }

            // clouds
            cloud1.moveAndDisplay()
            cloud2.moveAndDisplay()
            cloud3.moveAndDisplay()
            cloud4.moveAndDisplay()

            image(logoArt,logox,logoheight,200,100)

            image(board,185,340,100,50)
            fill('rgb(62,33,2)')
            textStyle(BOLD)
            textSize(20)
            text("START",200,373)
        }else if(next == true && proceed == false){

            cloud1.disappear()
            cloud2.disappear()
            cloud3.disappear()
            cloud4.disappear()

            if(logox == -200){
                logox = -200
            }else{
                logox -= 4
            }

            image(logoArt,logox,logoheight,200,100)

            

                profile1.display()
                profile2.display()

                image(board,185,340,100,50)

                fill('rgb(62,33,2)')
                textStyle(BOLD)
                textSize(20)
                noStroke()
                text("START",200,373)
                
                fill(225)
                strokeWeight(5)
                stroke(0)
                text("CHOOSE YOUR CHARACTER",100,133)
    
        }else{
            console.log("hi")
        }

        // cursor
        cursorW = 10
        cursorH = 20
        image(cursorImg,mouseX, mouseY,cursorW,cursorH)

        // console.log(mouseX, mouseY)
    }

    // game start
    else{

        image(outdoorMap,0,0)
        drawLevel(outdoorLevel1, outdoorTilesArtwork)
        drawLevel(outdoorLevel2, outdoorTilesArtwork)

        // Player
        player1.moveAndDisplay()
        if(mode == 1){
            player1.hoe()
        }else if(mode == 2){
            player1.pickaxe()
        }else if(mode == 3){
            player1.wateringCan()
        }

        // UI
        shop.display()
        waterStation.display()
        panel.display()

        for(let i=0; i < ui.length; i++){
            ui[i].display ()
        }
        // currency
        image(clockfaceArt,20, 0,100,30)

        player1.displayGold()


        // refill water 
        if(mode == 3){
            if(waterStation.collision(player1.x, player1.y)){
                if(!refillSound.isPlaying()){
                    refillSound.play()
                }      
                wateringCan.waterCount = 20
            }
        }

        wateringCan.waterBar()
        

        // shop
        if(shop.collision(player1.x, player1.y)){
            mode = 5
        }

        if(mode == 5){
            player1.movable = false
            if(shop.state == 0){
                shop.displaySelection()
            }else if (shop.state == 1){
                shop.displayShop()
            }else if (shop.state == 2){
                shop.displaySell()
            }
        }
        // Alert box
        if(mode == 6 || alert == true){
            fill(250,217,163)
            strokeWeight(4)
            stroke(91,72,34)
            rectMode(CENTER)
            rect(width/2, height/2, 200,100)

            // close button
            rect(width/2+80, height/2-30, 15,15)
            line(315,190,326,200)
            line(315,200,326,190)


            // alert text
            noStroke()
            fill(91,72,34)
            textAlign(CENTER)
            textStyle(BOLD)
            if(alertMsg == "noWater"){
                text("Sorry, please refill",width/2, height/2)
                text("your watering can",width/2, height/2 + 15)
                wateringCan.selected = true
            }
            if(alertMsg == "seedsMin"){
                text("Sorry, you have no more",width/2, height/2)
                text(seedsName + " seeds",width/2, height/2+15)
            }
            if(alertMsg == "seedsMax"){
                text("Sorry, you have reached",width/2, height/2)
                text("maximum amount of",width/2, height/2 + 15)
                text(seedsName + " seeds",width/2, height/2+30)
            }
            if(alertMsg == "shopMsgNone"){
                text("You didn't buy anything :(",width/2, height/2)
            }
            if(alertMsg == "shopMsgFail"){
                text("Sorry,",width/2, height/2)
                text("you don't have enough gold :(",width/2, height/2 + 15)
            }
            if(alertMsg == "shopMsgSuccess"){
                text("Your purchase is successful.",width/2, height/2)
                text("Your total is: $"+totalGold,width/2, height/2 + 15)
            }
            if(alertMsg == "sellMsgNone"){
                text("You didn't sell anything :(",width/2, height/2)
            }
            if(alertMsg == "sellMsgFail"){
                text("Sorry,",width/2, height/2)
                text("you don't have enough crops :(",width/2, height/2 + 15)
            }
            if(alertMsg == "sellMsgSuccess"){
                text("Your successfully sold your crops.",width/2, height/2)
                text("Your just made: $"+totalMade,width/2, height/2 + 15)
            }
            if(alertMsg == "shopMsgExceed"){
                text("Sorry,",width/2, height/2 - 15)
                text("You have no room in your storage.",width/2, height/2)
                text("Only 10 seeds per vegetable",width/2, height/2 + 15)
            }
            
            
            textAlign(LEFT)
            noStroke()
        }


        // cursor
        if(mode == 1){
            myCursor = hoeArt
            cursorW = 20
            cursorH = 20    
            imageMode(CENTER)
            image(myCursor,mouseX, mouseY,cursorW,cursorH)        
            imageMode(CORNER)
        }else if(mode == 3){
            myCursor = wateringCanArt
            cursorW = 20
            cursorH = 20    
            imageMode(CENTER)
            image(myCursor,mouseX+10, mouseY,cursorW,cursorH)        
            imageMode(CORNER)
        }else if(mode == 4){
            if(currentSeed == "cauliflower"){
                myCursor = cauliflowerSeedArt
            }else if(currentSeed == "kale"){
                myCursor = kaleSeedArt
            }else if(currentSeed == "bokchoy"){
                myCursor = bokchoySeedArt
            }
            cursorW = 20
            cursorH = 20    
            image(myCursor,mouseX, mouseY,cursorW,cursorH) 
        }else{
            myCursor = cursorImg
            cursorW = 10
            cursorH = 20
            image(myCursor,mouseX, mouseY,cursorW,cursorH)
        }
    }

}



// CLASSES START HERE --------------------------------------------------------------------------------------------------------
class Clouds{
    constructor(x,y,sizex, sizey){
        this.x = x
        this.y = y
        this.speedx = random(1,1.5)
        this.sizex = sizex
        this.sizey = sizey
    }
    moveAndDisplay(){

        if(this.x > -100){
            this.x -= this.speedx
        }else{
            this.x = 500
            this.y = random(30,300)
        }


        image(cloud1Art,this.x,this.y,this.sizex,this.sizey)
    }

    disappear(){
        if(this.x == -300){
            this.x = -300
        }else{
            this.x -= 4
        }
        image(cloud1Art,this.x,this.y,this.sizex,this.sizey)
    }
}

class Character{
    constructor(x,y,num,graphic){
        this.x = x
        this.y = y
        this.gender = num
        this.graphic = graphic
    }
    display(){
        if(this.gender == 1){
            if(this.x == 100){
                this.x = 100
            }else{
                this.x -= 4
            }

            image( this.graphic,this.x,this.y,100,100)
        }else{
            if(this.x == 270){
                this.x = 270
            }else{
                this.x -= 4
            }
            image( this.graphic,this.x,this.y,100,100)
        }
    }
}

class Player{
    constructor(startX, startY) {
        this.x = startX
        this.y = startY
        this.graphic 
        this.money = 10
        this.movable = true
        this.gender = "F"
        
    }
    
    moveAndDisplay(){

        if(this.movable == true){
            
            if(playerGender == "F"){
                this.gender = "F"
                this.graphic = playerArt1Front
            }else if(playerGender =="M"){
                this.gender = "M"
                this.graphic = playerArt2Front;
            }
        // sensors
        this.sensorLeft = this.x -7
        this.sensorRight = this.x+tileSize -10
        this.sensorTop = this.y + 10
        this.sensorBottom = this.y+tileSize -2
        this.middleX = this.x+tileSize/2 -8
        this.middleY = this.y+tileSize/2 +2
        
        let idLeft = getTile(this.sensorLeft,this.middleY,outdoorLevel1)
        let idRight = getTile(this.sensorRight,this.middleY,outdoorLevel1)
        let idTop = getTile(this.middleX, this.sensorTop,outdoorLevel1)
        let idDown = getTile(this.middleX, this.sensorBottom,outdoorLevel1)

        let idLeftLv2 = getTile(this.sensorLeft,this.middleY,outdoorLevel2)
        let idRightLv2 = getTile(this.sensorRight,this.middleY,outdoorLevel2)
        let idTopLv2 = getTile(this.middleX, this.sensorTop,outdoorLevel2)
        let idDownLv2 = getTile(this.middleX, this.sensorBottom,outdoorLevel2)

        // left
        if (keyIsDown(65)) {
            // ellipse(this.sensorLeft, this.middleY,5,5)
            if ( isSolid(idLeftLv2) === false ) {
                if(!stepSound.isPlaying()){
                    stepSound.play()
                }
                this.x -= 1
            }
            if(player1.gender == "F"){
                this.graphic = playerArt1L
            }else if(player1.gender =="M"){
                this.graphic = playerArt2L;
            }
          }
        // right
        if (keyIsDown(68)) {
            // ellipse(this.sensorRight, this.middleY,5,5)
            if ( isSolid(idRightLv2) === false ) {
                if(!stepSound.isPlaying()){
                    stepSound.play()
                }
                this.x += 1
            }
            if(player1.gender == "F"){
                this.graphic = playerArt1R
            }else if(player1.gender =="M"){
                this.graphic = playerArt2R;
            }        }
        // top
        if (keyIsDown(87)) {
            // ellipse(this.middleX, this.sensorTop,5,5)

            if ( isSolid(idTopLv2) === false ) {
                if(!stepSound.isPlaying()){
                    stepSound.play()
                }
                this.y -= 1
            }
            if(player1.gender == "F"){
                this.graphic = playerArt1Back
            }else if(player1.gender =="M"){
                this.graphic = playerArt2Back;
            }
        }
        // down
        if (keyIsDown(83)) {
            // ellipse(this.middleX, this.sensorBottom,5,5)

            if ( isSolid(idDownLv2) === false ) {
                if(!stepSound.isPlaying()){
                    stepSound.play()
                }
                this.y += 1
            }
            if(player1.gender == "F"){
                this.graphic = playerArt1Front
            }else if(player1.gender =="M"){
                this.graphic = playerArt2Front;
            }        
        }

        // SPACE BAR 
        if (keyIsDown(32)) {
            // till the soil
            if(mode == 1){
                if(isSoil(idLeft) === true ){
                    tillSoil(this.sensorLeft,this.middleY)
                    if(!hoeSound.isPlaying()){
                        hoeSound.play()
                    }
                }
                else if(isSoil(idDown) === true){
                    if(!hoeSound.isPlaying()){
                        hoeSound.play()
                    }
                    tillSoil(this.middleX, this.sensorBottom)
                }
            }

            // harvest
            if(mode == 2){
                if(plantable(idLeft) || plantable(idDown)){
                    if(mature(getTile(this.sensorLeft,this.middleY,outdoorLevel2)) === true ){
                        if(!pickaxeSound.isPlaying()){
                            pickaxeSound.play()
                        }
                        harvest(this.sensorLeft,this.middleY)
                    }
                    else if(mature(getTile(this.middleX, this.sensorBottom,outdoorLevel2)) === true){
                        if(!pickaxeSound.isPlaying()){
                            pickaxeSound.play()
                        }
                        harvest(this.middleX, this.sensorBottom)
                    }
                }
            }
        }
        }
        imageMode(CENTER)
        image(this.graphic, this.x, this.y)
    }

    displayGold(){        
        fill(109,0,0)
        textStyle(BOLD)
        textSize(14)
        text(this.money,45,23)
    }

    hoe(){
        image(hoeArt,this.x-10, this.y,16,16)
    }
    pickaxe(){
        image(pickaxeArt,this.x-10, this.y,16,16)
    }
    wateringCan(){
        image(wateringCanArt,this.x-10, this.y,16,16)
    }

}

class UserPanel {
    constructor(x,y){
        this.x = x
        this.y = y
    }

    display(){
        fill(250,217,163)
        strokeWeight(4)
        stroke(91,72,34)
        rectMode(CENTER)
        rect(this.x, this.y,300,40)

        // fill(196,142,93)
        strokeWeight(1)
        stroke(196,142,93)
        rect(120,420,30,30)
        rect(150,420,30,30)
        rect(180,420,30,30)
        rect(210,420,30,30)
        rect(240,420,30,30)
        rect(270,420,30,30)
        rect(300,420,30,30)
        rect(330,420,30,30)
        rect(360,420,30,30)
    }
}

class Tools {
    constructor(graphic,x,y){
        this.x = x
        this.y = y 
        this.graphic = graphic
        this.waterCount = 20
        this.refill = false
        this.selected = false
        this.deselect = false
        this.playSound = false
    }

    display(){
        
        if(this.selected == true){
            strokeWeight(3)
            stroke(230,146,64)
            rect(this.x,this.y,30,30)
        }
        
        imageMode(CENTER)
        image(this.graphic, this.x, this.y,30,30)
        imageMode(CORNER)
    }

    waterBar(){
        // fill("rgb(135,206,235)")
        rectMode(CORNER)
        fill(250,217,163)
        stroke(0)
        strokeWeight(1)
        rect(this.x-10, this.y-14, 20,5)

        
        
        noStroke()
        fill("rgb(135,206,235)")
        rect(this.x-10, this.y-13.5, this.waterCount,4)
        fill('rgb(90, 47, 15)')    
    }
}

class Seeds {
    constructor(graphic,x,y){
        this.x = x
        this.y = y 
        this.graphic = graphic
        this.price
        this.selected = false
        this.amount = 5
    }

    display(){
        
        if(this.selected == true){
            strokeWeight(3)
            stroke(230,146,64)
            rect(this.x,this.y,30,30)
        }

        imageMode(CENTER)
        image(this.graphic, this.x, this.y,30,30)
        imageMode(CORNER)

        // display amount
        noStroke()
        fill(0)
        textStyle(BOLD)
        textSize(10)
        text(this.amount,this.x+10, this.y+15)
        noFill()
    }

}

class Crops {
    constructor(x,y){
        this.x = x
        this.y = y 
        this.vegetable 
        this.stage = 0
    }

    cauliflower(){
        if(this.stage == 1){
            changeTile(mouseX,mouseY,outdoorLevel2,1951)
        }
        else if(this.stage == 2){
            changeTile(mouseX,mouseY,outdoorLevel2,1952)
        }
        else if(this.stage == 3){
            changeTile(mouseX,mouseY,outdoorLevel2,1953)
        }
        else if(this.stage == 4){
            changeTile(mouseX,mouseY,outdoorLevel2,1954)
        }
        else if(this.stage == 5){
            matureSound.play()
            changeTile(mouseX,mouseY,outdoorLevel2,1925)
        }
    }

    kale(){
        if(this.stage == 1){
            changeTile(mouseX,mouseY,outdoorLevel2,1756)
        }
        else if(this.stage == 2){
            changeTile(mouseX,mouseY,outdoorLevel2,1781)
        }
        else if(this.stage == 3){
            changeTile(mouseX,mouseY,outdoorLevel2,1806)
        }
        else if(this.stage == 4){
            changeTile(mouseX,mouseY,outdoorLevel2,1831)
        }
        else if(this.stage == 5){
            matureSound.play()
            changeTile(mouseX,mouseY,outdoorLevel2,1856)
        }
    
    }

    bokchoy(){
        if(this.stage == 1){
            changeTile(mouseX,mouseY,outdoorLevel2,1757)
        }
        else if(this.stage == 2){
            changeTile(mouseX,mouseY,outdoorLevel2,1782)
        }
        else if(this.stage == 3){
            changeTile(mouseX,mouseY,outdoorLevel2,1807)
        }
        else if(this.stage == 4){
            changeTile(mouseX,mouseY,outdoorLevel2,1832)
        }
        else if(this.stage == 5){
            matureSound.play()
            changeTile(mouseX,mouseY,outdoorLevel2,1857)
        }
    }

}

class Shop {
    constructor(x,y){
        this.x = x
        this.y = y
        this.state = 0
    }

    display(){
        rectMode(CENTER)
        noStroke()
        fill('rgba(0,0,0, 0)')
        rect(this.x,this.y,32,30)
        noFill()
        rectMode(CORNER)
    }

    displaySelection(){
        imageMode(CENTER)
        image(shopArt,width/2,height/2,350,300)
        // imageMode(CORNER)

        textSize(17)
        text("FARMER'S SHOP",170,137)

        // sell
        image(board,width/2, height/2 -30,100,50)
        textSize(12)
        text("BUY",225,height/2-25)

        // buy
        image(board,width/2, height/2 +30,100,50)
        text("SELL",224,height/2+35)

        imageMode(CORNER)
        image(closeBtnArt,340,115,30,30)

    }

    displayShop(){

        imageMode(CENTER)
        image(shopArt,width/2,height/2,350,300)
        imageMode(CORNER)

        textSize(17)
        text("FARMER'S SHOP",170,137)

        // cauliflower
        image(cauliflowerSeedArt,116,170,50,50) // seed image
        image(goldArt,125,222,15,15)            // gold icon
        fill('rgb(90, 47, 15)')
        textSize(12)
        text("Cauliflower",110,165)             // seed name
        text(cauliflowerSeed.price,140,233)  // seed price
        text(c_purchased,140,250)  // number of seed
        image(leftArrowArt,120,240,15,15)   // left arrows
        image(rightArrowArt,152,239,15,15)   // right arrows

        // kale
        image(kaleSeedArt,216,170,50,50)
        image(goldArt,225,222,15,15)
        text("Kale",225,165)
        text(kale.price,240,233)
        text(k_purchased,240,250)  // number of seed
        image(leftArrowArt,220,240,15,15)   // left arrows
        image(rightArrowArt,252,239,15,15)   // right arrows

        // bokchoy
        image(bokchoySeedArt,316,170,50,50)
        image(goldArt,325,222,15,15)
        text("Bok choy",315,165)
        text(bokchoy.price,340,233)
        text(b_purchased,340,250)  // number of seed
        image(leftArrowArt,320,240,15,15)   // left arrows
        image(rightArrowArt,352,239,15,15)   // right arrows

        // shop npc 
        image(dialogueArt,120,270,190,70)
        image(ownerArt,250,281,40,40)
        textSize(10)
        text("Penny",255,331)
        text("These are the new",135,295)
        text("seeds that came in",135,308)
        text("today!",135,321)

        image(okBtnArt,340,305,30,30)
        image(closeBtnArt,340,115,30,30)

    }
    
    displaySell(){
        imageMode(CENTER)
        image(shopArt,width/2,height/2,350,300)
        imageMode(CORNER)

        textSize(17)
        text("Sell Your Crops",175,136)

        image(cauliflowerArt,116,170,50,50) // cauliflower image
        image(goldArt,125,222,15,15)            // gold icon
        fill('rgb(90, 47, 15)')
        textSize(12)
        text("Cauliflower",110,165)             // seed name
        text(cauliflowerIcon.price,140,233)  // seed price
        text(c_sold,140,250)  // number of seed
        image(leftArrowArt,120,240,15,15)   // left arrows
        image(rightArrowArt,152,239,15,15)   // right arrows

        // kale
        image(kaleArt,216,170,50,50)
        image(goldArt,225,222,15,15)
        text("Kale",225,165)
        text(kaleIcon.price,240,233)
        text(k_sold,240,250)  // number of seed
        image(leftArrowArt,220,240,15,15)   // left arrows
        image(rightArrowArt,252,239,15,15)   // right arrows

        // bokchoy
        image(bokchoyArt,316,170,50,50)
        image(goldArt,325,222,15,15)
        text("Bok choy",315,165)
        text(bokchoyIcon.price,340,233)
        text(b_sold,340,250)  // number of seed
        image(leftArrowArt,320,240,15,15)   // left arrows
        image(rightArrowArt,352,239,15,15)   // right arrows

        // shop npc 
        image(dialogueArt,120,270,190,70)
        image(ownerArt,250,281,40,40)
        textSize(10)
        text("Penny",255,331)
        text("Please feel free to",135,295)
        text("sell any excess ",135,308)
        text("vegetables you have",135,321)

        image(okBtnArt,340,305,30,30)
        image(closeBtnArt,340,115,30,30)
    }

    collision(x,y){
        if(dist(x,y, this.x, this.y) < 15) {
            return true
        }
        return false
    }
    
}

class WaterBox{
    constructor(x,y){
        this.x = x
        this.y = y
        this.refill = false
    }

    display(){
        rectMode(CENTER)
        noStroke()
        fill('rgba(0,0,0, 0)')
        rect(this.x,this.y,32,16)
        noFill()
        rectMode(CORNER)
    }

    collision(x,y){
        if(dist(x,y, this.x, this.y) < 15) {
            return true
        }
        return false
    }
}



//  FUNCTIONS START HERE --------------------------------------------------------------------------------------------------------
// Tile functions
function drawTiles(mapName, id, xPos, yPos){
    let tilesPerRow = mapName.width/tileSize

    let x = int(id % tilesPerRow) * tileSize
    let y = int(id / tilesPerRow) * tileSize

    // image( FILE, DEST_X, DEST_Y, DEST_WIDTH, DEST_HEIGHT, SOURCE_X, SOURCE_Y, SOURCE_WIDTH, SOURCE_HEIGHT)
    image(outdoorTilesArtwork, xPos, yPos, tileSize, tileSize, x, y, tileSize, tileSize)
}

function drawLevel(levelName,name){
    for(let y=0; y < levelName.length; y++){
        for(let x=0; x < levelName[y].length; x++){
            drawTiles(name, levelName[y][x], x*tileSize, y*tileSize)
        }
    }
}

function getTile(x,y,mapName){
    x = int(x/tileSize)
    y = int(y/tileSize)
    return mapName[y][x]
}

function getTilePos(x,y){

    return ((y * tileSize) + x)
}

function contains(value){
    for(let i=0; i < cropsPos.length; i++){
        if(cropsPos[i] === value){
            return true
        }
    }
    return false
}


//Soil functions
function isSolid(id){
    if(id === 759){
        return true
    }
    return false
}

function isSoil(id){
    if(id === 206 || id === 226 || id === 227 || id === 488 || id === 564){
        return true
    }
    return false
}

function tillSoil(x,y){

    changeTile(x,y,outdoorLevel1,680)
}


// Shovel Function
function shovel(x,y){
    let soilTiles = [226,227,564,206,488,226,227,226,227]
    let randomSoil = int(random(0,9))

    x = int(x/tileSize)
    y = int(y/tileSize)

    // remove each crop from array
    let currentNumber = getTilePos(x,y)
    let currentPosition = cropsPos.indexOf(currentNumber)
    cropsPos.splice(currentPosition, 1)
    crops.splice(currentPosition, 1)

    outdoorLevel2[y][x] = inv
    outdoorLevel1[y][x] = soilTiles[randomSoil]

}

// Plant funnctions
function plantable(id){
    if(id === 680){
        return true
    }
    return false
}

function changeTile(x,y, mapName, newTile){
    x = int(x/tileSize)
    y = int(y/tileSize)

    mapName[y][x] = newTile
}

function plantSeed(x,y,stage){
    x = int(x/tileSize)
    y = int(y/tileSize)

    let currentNumber = getTilePos(x,y)
    cropsPos.push(currentNumber)
    
    if(currentSeed == "cauliflower"){
        if(stage === 0){
            outdoorLevel2[y][x] = 1950  
            let newCrop = new Crops(x,y)
            newCrop.vegetable = "cauliflower"
            crops.push(newCrop) 
        }
    }
     if(currentSeed == "bokchoy"){
        if(stage === 0){
            outdoorLevel2[y][x] = 1732  
            let newCrop = new Crops(x,y)
            newCrop.vegetable = "bokchoy"
            crops.push(newCrop) 
        }   
    }
    else if(currentSeed == "kale"){
        if(stage === 0){
            outdoorLevel2[y][x] = 1731  
            let newCrop = new Crops(x,y)
            newCrop.vegetable = "kale"
            crops.push(newCrop) 
        }   
    }

}


// Water function 
function watering(x,y){
    x = int(x/tileSize)
    y = int(y/tileSize)

    // get crops position
    let currentNumber = getTilePos(x,y)
    let currentPosition = cropsPos.indexOf(currentNumber)

    // check if ur mouse location has a crop planted or not
    if(contains(getTilePos(x,y))){
        let currentCrop = crops[currentPosition]

        if(currentCrop.stage < 6){
            currentCrop.stage += 1

            if(currentCrop.vegetable === "cauliflower"){
                currentCrop.cauliflower()
            }else if(currentCrop.vegetable  === "kale"){
                currentCrop.kale()
            }else if(currentCrop.vegetable  === "bokchoy"){
                currentCrop.bokchoy()
            }
            
        }else{
            currentCrop.stage = 5
        }
    }

}


// Harvest function
function harvest(x,y){
    let currentCrop = getTile(x,y,outdoorLevel2)

    // update vegetable amount in storage    
    x = int(x/tileSize)
    y = int(y/tileSize)

    // remove crop from array
    let currentNumber = getTilePos(x,y)
    let currentPosition = cropsPos.indexOf(currentNumber)

    // cauliflower
    if(currentCrop == 1925){
        if(cauliflowerIcon.amount < 10){
            cauliflowerIcon.amount += 1
            cropsPos.splice(currentPosition, 1)
            crops.splice(currentPosition, 1)
            outdoorLevel2[y][x] = inv
        }else{
            
            mode = 6
            alertMsg = "seedsMax"
        }
    }else if(currentCrop == 1856){
        if(kaleIcon.amount < 10){
            kaleIcon.amount += 1
            cropsPos.splice(currentPosition, 1)
            crops.splice(currentPosition, 1)
            outdoorLevel2[y][x] = inv
        }else{
            
            mode = 6
            alertMsg = "seedsMax"
        }
    }else if(currentCrop == 1857){
        if(bokchoyIcon.amount < 10){
            bokchoyIcon.amount += 1            
            cropsPos.splice(currentPosition, 1)
            crops.splice(currentPosition, 1)
            outdoorLevel2[y][x] = inv
        }else{
            
            mode = 6
            alertMsg = "seedsMax"
        }
    }

}

function mature(id){
    if(id === 1925 || id === 1857 || id === 1856 ){
        return true
    }
    return false
}


function mouseClicked(){

    if(gameStart == false){
        if(next == false && proceed  == false){
            if(mouseX > 186 && mouseX < 283 && mouseY > 340 && mouseY < 388){
                gameStartSound.play()
                next = true
            }
        }
        else if (next == true && proceed == false){

            // select character
            if(mouseX > 104 && mouseX < 196 && mouseY > 201 && mouseY < 293){
                playerGender = "F"
                femaleSound.play()
                profile1.graphic = playerArt1smile
                profile2.graphic = playerArt2

            }else if(mouseX > 276 && mouseX < 364 && mouseY > 201 && mouseY < 293){
                playerGender = "M"
                maleSound.play()

                profile1.graphic = playerArt1
                profile2.graphic = playerArt2smile

            }else if(mouseX > 186 && mouseX < 283 && mouseY > 340 && mouseY < 388){
                gameStartSound.play()
                
                proceed = true            
            }
        }
        if(next == true && proceed == true){
            if(mouseX > 186 && mouseX < 283 && mouseY > 340 && mouseY < 388){
                gameStart = true
            }
        }
    }

    // Select Tools/Seeds
    if(mouseY > 407 && mouseY < 437){
        mouseClickSound.play()

        for(let i=0; i < ui.length; i++){
            ui[i].selected = false
            // hoe
            if(mouseX > 106 && mouseX < 136){
                if(ui[0].deselect == true){
                    ui[0].selected = false
                    ui[0].deselect = false
                    mode = 0
                }else{
                    ui[0].selected = true
                    ui[0].deselect = true
                    mode = 1
                }
            }
            // pickaxe
            else if(mouseX > 136 && mouseX < 166){
                if(ui[1].deselect == true){
                    ui[1].selected = false
                    ui[1].deselect = false
                    mode = 0
                }else{
                    ui[1].selected = true
                    ui[1].deselect = true
                    mode = 2
                }
            }
            // watering can
            else if(mouseX > 166 && mouseX < 196){
                if(ui[2].deselect == true){
                    ui[2].selected = false
                    ui[2].deselect = false
                    mode = 0
                }else{
                    ui[2].selected = true
                    ui[2].deselect = true
                    mode = 3
                }
            }
            // Cauliflower seed 
            else if(mouseX > 196 && mouseX < 226){
                if(ui[3].deselect == true){
                    ui[3].selected = false
                    ui[3].deselect = false
                    mode = 0

                }else{
                    ui[3].selected = true
                    ui[3].deselect = true
                    mode = 4
                    currentSeed = "cauliflower"
                }
            }
            // kale seed
            else if(mouseX > 226 && mouseX < 256){
                if(ui[4].deselect == true){
                    ui[4].selected = false
                    ui[4].deselect = false
                    mode = 0

                }else{
                    ui[4].selected = true
                    ui[4].deselect = true
                    mode = 4
                    currentSeed = "kale"

                }
            }
            // bokchoy
            else if(mouseX > 256 && mouseX < 286){
                if(ui[5].deselect == true){
                    ui[5].selected = false
                    ui[5].deselect = false
                    mode = 0
                    currentSeed = "bokchoy"

                }else{
                    ui[5].selected = true
                    ui[5].deselect = true
                    mode = 4
                }
            }

            }
        }
    
    // shovel mode
    if(mode == 1){
        if(plantable(getTile(mouseX,mouseY, outdoorLevel1))){
            shovel(mouseX, mouseY)
            shovelSound.play()
        }
    }

    // water mode
    if(mode == 3){
        if(plantable(getTile(mouseX,mouseY, outdoorLevel1))){
            if(wateringCan.waterCount > 0){
                waterSound.play()
                watering(mouseX,mouseY)
                wateringCan.waterCount -= 1
            }else{
                mode = 6
                alertMsg = "noWater"
                warningSound.play()
            }
        }
    }

    // plant seeds mode
    if(mode == 4){

        seedsName = currentSeed
        if(currentSeed == "cauliflower"){
            if(cauliflowerSeed.amount != 0){
                if(plantable(getTile(mouseX,mouseY, outdoorLevel1))){
                    if(contains(getTilePos(int(mouseX/tileSize),int(mouseY/tileSize)))){
                    }else{
                        seedSound.play()
                        plantSeed(mouseX,mouseY,0)
                        cauliflowerSeed.amount -= 1
                    }
                }
            }
            else{
                mode = 6
                alertMsg = "seedsMin" 
                warningSound.play()           
            }
        }
        else if(currentSeed == "kale"){
            if(kale.amount != 0){
                if(plantable(getTile(mouseX,mouseY, outdoorLevel1))){
                    if(contains(getTilePos(int(mouseX/tileSize),int(mouseY/tileSize)))){
                    }else{
                        seedSound.play()

                        plantSeed(mouseX,mouseY,0)
                        kale.amount -= 1
                    }
                }
            }else{
                mode = 6
                alertMsg = "seedsMin" 
                warningSound.play()            
            }
        }
        else if(currentSeed == "bokchoy"){
            if(bokchoy.amount != 0){
                if(plantable(getTile(mouseX,mouseY, outdoorLevel1))){
                    if(contains(getTilePos(int(mouseX/tileSize),int(mouseY/tileSize)))){
                    }else{
                        seedSound.play()

                        plantSeed(mouseX,mouseY,0)
                        bokchoy.amount -= 1
                    }
                }
            }else{
                warningSound.play()
                mode = 6
                alertMsg = "seedsMin"  
            }
        }
    }   

    // shop mode
    if(mode == 5){
        mouseClickSound.play()

        if(shop.state == 0){
            // mouseClickSound.play()
            if(mouseX > 192 && mouseX < 290){
                if(mouseY > 173 && mouseY < 220){
                    shop.state = 1
                }else if (mouseY > 233 && mouseY < 281){
                    shop.state = 2
                }
            }

        }

        // buy seeds
        else if(shop.state == 1){
            // buy seeds    
            if(mouseY > 242 && mouseY < 256){
                // cauliflower seeds
                // leftBtn
                if(mouseX > 123 && mouseX < 135){
                    if(c_purchased > 0){
                        c_purchased -= 1
                    }else{
                        c_purchased = 0
                    }
                }
                // rightBtn
                else if(mouseX > 154 && mouseX < 167){
                    if(c_purchased < 5){
                        c_purchased += 1
                    }else{
                        c_purchased = 5
                    }
                }

                // kale seeds
                // leftBtn
                if(mouseX > 221 && mouseX < 235){
                    if(k_purchased > 0){
                        k_purchased -= 1
                    }else{
                        k_purchased = 0
                    }
                }
                // rightBtn
                else if(mouseX > 253 && mouseX < 267){
                    if(k_purchased < 5){
                        k_purchased += 1
                    }else{
                        k_purchased = 5
                    }
                }

                // bokchoy seeds
                // leftBtn
                if(mouseX > 321 && mouseX < 336){
                    if(b_purchased > 0){
                        b_purchased -= 1
                    }else{
                        b_purchased = 0
                    }
                }
                // rightBtn
                else if(mouseX > 353 && mouseX < 368){
                    if(b_purchased < 5){
                        b_purchased += 1
                    }else{
                        b_purchased = 5
                    }
                }

            }

            // ok button
            if(mouseX > 341 && mouseX < 371 && mouseY > 308 && mouseY < 353){
                // computeTotal(c_purchased,k_purchased,b_purchased)
                let totalC = c_purchased * cauliflowerSeed.price
                let totalK = k_purchased * kale.price
                let totalB = b_purchased * bokchoy.price
                let total = (totalB+totalC+totalK)
                
                if(total === 0){
                    warningSound.play()
                    alert = true
                    alertMsg = "shopMsgNone"
                }
                else{
                    if(player1.money >= total){

                        if(cauliflowerSeed.amount < 10 && kale.amount < 10 && bokchoyIcon.amount < 10){
                            buySound.play()

                            cauliflowerSeed.amount += c_purchased
                            kale.amount += k_purchased
                            bokchoy.amount += b_purchased

                            player1.money -= total

                            totalGold = total
                            alert = true
                            alertMsg = "shopMsgSuccess"

                            c_purchased = 0
                            k_purchased = 0
                            b_purchased = 0
                        }else{
                            warningSound.play()

                            alert = true
                            alertMsg = "shopMsgExceed"
                        }
                    }else{
                        warningSound.play()
                        alert = true
                        alertMsg = "shopMsgFail"
                    }
                }
            }
        }

        // sell crops
        else if(shop.state == 2){
            // sell   
            if(mouseY > 242 && mouseY < 256){
                // cauliflower seeds
                // leftBtn
                if(mouseX > 123 && mouseX < 135){
                    if(c_sold > 0){
                        c_sold -= 1
                    }else{
                        c_sold = 0
                    }
                }
                // rightBtn
                else if(mouseX > 154 && mouseX < 167){
                    if(c_sold < 10){
                        c_sold += 1
                    }else{
                        c_sold = 10
                    }
                }

                // kale seeds
                // leftBtn
                if(mouseX > 221 && mouseX < 235){
                    if(k_sold > 0){
                        k_sold -= 1
                    }else{
                        k_sold = 0
                    }
                }
                // rightBtn
                else if(mouseX > 253 && mouseX < 267){
                    if(k_sold < 10){
                        k_sold += 1
                    }else{
                        k_sold = 10
                    }
                }

                // bokchoy seeds
                // leftBtn
                if(mouseX > 321 && mouseX < 336){
                    if(b_sold > 0){
                        b_sold -= 1
                    }else{
                        b_sold = 0
                    }
                }
                // rightBtn
                else if(mouseX > 353 && mouseX < 368){
                    if(b_sold < 10){
                        b_sold += 1
                    }else{
                        b_sold = 10
                    }
                }

            }


            // ok button
            if(mouseX > 341 && mouseX < 371 && mouseY > 308 && mouseY < 353){
                // computeTotal(c_purchased,k_purchased,b_purchased)
                let totalC = c_sold * cauliflowerIcon.price
                let totalK = k_sold * kaleIcon.price
                let totalB = b_sold * bokchoyIcon.price
                let total = (totalB+totalC+totalK)
                
                if(total === 0){
                    warningSound.play()
                    alert = true
                    alertMsg = "sellMsgNone"
                }
                else{
                    if(cauliflowerIcon.amount >= c_sold && kaleIcon.amount >= k_sold && bokchoyIcon.amount >= b_sold){
                        sellSound.play()

                        player1.money += total
                        
                        totalMade = total
                        cauliflowerIcon.amount -= c_sold
                        kaleIcon.amount -= k_sold
                        bokchoyIcon.amount -= b_sold
                        
                        alert = true
                        alertMsg = "sellMsgSuccess"

                        c_sold = 0
                        k_sold = 0
                        b_sold = 0
                    }else{
                        if(cauliflowerIcon.amount < c_sold || kaleIcon.amount < k_sold ||bokchoyIcon.amount < b_sold){
                            warningSound.play()
                            alert = true
                            alertMsg = "sellMsgFail"
                        }
                

                    }


                }
            }
        }

        // close Button
        if(mouseX > 343 && mouseX < 370 && mouseY > 118 && mouseY < 144){
            closeSound.play()
            player1.movable = true

            // reset purchased
            c_purchased = 0
            k_purchased = 0
            b_purchased = 0
            c_sold = 0
            k_sold = 0
            b_sold = 0

            if(shop.state == 1 || shop.state == 2){
                shop.state = 0
            }
            
            // player1.x -= 20
            player1.y += 10
            mode = 0
        }
        
        
    }

    // alert box
    if(mode == 6){
        // warningSound.play()

        player1.movable = false

        for(let i=0; i < ui.length; i++){
            ui[i].selected = false
        }

        // close alert box
        if(mouseX >310 && mouseX < 326 && mouseY > 190 && mouseY < 200){
            closeSound.play()
            player1.movable = true
            mode = 0
        }
    }

    if (alert == true){

        player1.movable = false

        if(mouseX >310 && mouseX < 326 && mouseY > 190 && mouseY < 200){
            closeSound.play()

            player1.movable = true
            alert = false

            if(mode == 3){
                mode = 0
            }
        }
    }

    

}



// adjust window
function repositionCanvas() {
    var xPos = int(windowWidth/2 - 0.5*width);
    var yPos = int(windowHeight/2 - 0.5*height);
    theCanvas.position(xPos, yPos);
}

function windowResized() {
    repositionCanvas();
}