let tilesetArtwork, player1art
let tileSize = 16
let xOffset = 0
let yOffset = 0
let cursorX = 0
let cursorY = 0
let htmlElement;

function preload() {
  // tilesetArtwork = loadImage('assets/outdoors.png')
  tilesetArtwork = loadImage('assets/sprites/outdoors.png')
  
  // player1art = loadImage("assets/player1.png")
}

function setup() {
  createCanvas(1000,800)
  stroke(0,255,0)
  strokeWeight(1)
  noFill()
  htmlElement = document.getElementById("tileId")
  frameRate(10)
}

function draw() {
  background(0)
  image(tilesetArtwork, xOffset, yOffset)
  rect(cursorX, cursorY, tileSize, tileSize)

  if (keyIsPressed) {
    handleKeys(tilesetArtwork)
  }
}

function handleKeys(imageName) {
  if (key == 'D' || key == 'd') {
    if (cursorX + abs(xOffset) < imageName.width - tileSize) {
      if (cursorX >= width-tileSize) {
        xOffset -= tileSize
      }
      else {
        cursorX += tileSize
      }
    }
  }

  if (key == 'A' || key == 'a') {
    if (cursorX + abs(xOffset) > 0) {
      if (cursorX <= 0) {
        xOffset += tileSize
      }
      else {
        cursorX -= tileSize
      }
    }
  }

  if (key == 'S' || key == 's') {
    if (cursorY + abs(yOffset) < imageName.height - tileSize) {
      if (cursorY >= height-tileSize) {
        yOffset -= tileSize
      }
      else {
        cursorY += tileSize
      }
    }
  }

  if (key == 'W' || key == 'w') {
    if (cursorY + abs(yOffset) > 0) {
      if (cursorY <= 0) {
        yOffset += tileSize
      }
      else {
        cursorY -= tileSize
      }
    }
  }

//   console.log("x: " + int( (cursorX + abs(xOffset)) / tileSize ))
//   console.log("y: " + ((cursorY+abs(yOffset) ) / tileSize) * (tilesetArtwork.width/tileSize))
  htmlElement.innerHTML = int( (cursorX + abs(xOffset)) / tileSize ) + ((cursorY+abs(yOffset) ) / tileSize) * (imageName.width/tileSize)
}

function drawTile(i, xPos, yPos, tileName) {
  let x = int(i % (tileName.width/tileSize)) * tileSize
  let y = int(i / (tileName.width/tileSize)) * tileSize
  image(tileName, xPos, yPos, scaleSize, scaleSize, x, y, tileSize, tileSize)
}
